<?php
// ----------------------------------------------------------------------------------------
// Topic:     News Database based on Files
// File:      rss.inc.php
// ----------------------------------------------------------------------------------------


      /**
      * Topic:  RSS file export
      * Author: urs_at_circle_dot_ch
      * Date:   20-11-2000
      * Help:   http://my.netscape.com/publish/help/mnn20/
      *
      */
      function export_rdf($datafile) {

          global $channel;

          $content = file($datafile);
          $size = count($content);

          for($i=0; $i<count($content); $i++):
              $myLINES[$i] = explode("|",$content[$i]);
          endfor;

          if (!$fp = @fopen($channel[datadir] . $channel[outputfile], "w+")) {
              echo ("Unable to write to outputfile");
          } else {
              fputs ( $fp, "<?xml version=\"1.0\" encoding=\"$channel[rdf_encoding]\"?>\n\n" );
              fputs ( $fp, "<!DOCTYPE rss PUBLIC \"-//Netscape Communications//DTD RSS 0.91//EN\"\n \"http://my.netscape.com/publish/formats/rss-0.91.dtd\">\n" );
              fputs ( $fp, "<rss version=\"0.91\">\n\n" );
              fputs ( $fp, "<channel>\n" );
              fputs ( $fp, "<title>$channel[rdf_title]</title>\n ");
              fputs ( $fp, "<link>$channel[rdf_link]</link>\n");
              fputs ( $fp, "<description>$channel[rdf_descr]</description>\n");
              fputs ( $fp, "<language>$channel[rdf_lang]</language>\n");
              fputs ( $fp, "<copyright>$channel[rdf_copyright]</copyright>\n");
              fputs ( $fp, "<managingEditor>$channel[rdf_editor]</managingEditor>\n");
              fputs ( $fp, "<image>\n");
              fputs ( $fp, "<title>$channel[rdf_title]</title>\n");
              fputs ( $fp, "<url>$channel[rdf_url]</url>\n");
              fputs ( $fp, "<link>$channel[rdf_link]</link>\n");
              fputs ( $fp, "<width>120</width>\n");
              fputs ( $fp, "<height>20</height>\n");
              fputs ( $fp, "<description>$channel[rdf_descr]</description>\n");
              fputs ( $fp, "</image>\n\n");

              // special handling of ten first messages
              if(count($content) < 11){
                  $lowerlimit = 0;
              } else {
                  $lowerlimit = count($content)-11;
              }

              for($j=count($content)-1; $j>$lowerlimit; $j--) {
                  fputs ( $fp, "<item>\n" );
                  $title  = "<title>" . htmlspecialchars(stripslashes($myLINES[$j][2])) . "</title>\n";
                  $link   = "<link>" . $channel["rdf_link"] . "/zoom.php?id=" . $myLINES[$j][0] . "</link>\n";
                  fputs ( $fp,  $title );
                  fputs ( $fp,  $link );
                  fputs ( $fp, "</item>\n\n" );
              }
          }

          fputs ( $fp, "</channel>\n");
          fputs ( $fp, "</rss>\n");
          fclose( $fp );

      }

?>