<?php
// ----------------------------------------------------------------------------------------
// Topic:     News Database based on Files
// File:      shared.inc.php
// ----------------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------------
// functions : look & feel
// ----------------------------------------------------------------------------------------

      function commonHeader($title,$style) {

      global $PHP_SELF, $HTTP_ENV_VARS, $conf, $stamp;
      ?>
      <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
      <html><head><title><?php echo $title; ?></title><link rel="stylesheet" href="<?php echo $style; ?>">

      <SCRIPT language=JavaScript>
      <!-- Hide from older browsers

            function passFORWARD(){
              location = "/whatever_dir/whatever_file.php?login=" + document.loginform.login.value;
            }

            function publish() {
              document.editform.submit();
            }

            function javaWindow(url,name,w,h) {
              javaWin = window.open(url, name,'toolbar=yes,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width='+w+',height='+h+',left=10,top=10');
              javaWin.focus()
            }

            function deleteITEM(cmd){
              var winConfirm = window.confirm('Do you really want to delete this article?');
              if(winConfirm){
                location.href=(cmd);
              }
             }

             function insertITEM(cmd){
               var winConfirm = window.confirm('Would you like to add an article here?');
               if(winConfirm){
                 location.href=(cmd);
               }
             }

       // Unhide -->
       </SCRIPT>

       </head>

       <!-- start body -->
       <body>
       <div align="center">

       <!-- start navigation -->
       <TABLE FRAME=void height="20" bgcolor="#CCCCFF" width="<?php echo $conf[tableWidth]; ?>" >
       <TR>
         <TD width="60%">
         <a href="<?php echo basename($PHP_SELF)."?cmd=new"."&".$stamp; ?>">new</a>&nbsp;|
         <a href="<?php echo basename($PHP_SELF)."?cmd=list"."&".$stamp; ?>">headlines</a>&nbsp;|
         <a href="<?php echo basename($PHP_SELF)."?cmd=rdf"."&".$stamp; ?>">rdf</a>&nbsp;|
         <a href="<?php echo basename($PHP_SELF)."?cmd=wml"."&".$stamp; ?>">wap</a>&nbsp;|
         <a href="<?php echo basename($PHP_SELF)."?cmd=backup"."&".$stamp; ?>">backup</a>
         </TD>
         <TD ALIGN="left" style="font:9pt" width="30%"><?php echo $conf[version]; ?></TD>
         <TD ALIGN="right" style="font:9pt" width="20%"><a href="<?php echo "http://".$HTTP_ENV_VARS["SERVER_NAME"]; ?>">home</a>&nbsp;
         <a href="javascript:javaWindow('<?php echo "help.php"; ?>','help',300,600);"><img src="images/question.gif" border="no"></a>
         </TD>
       </TR>
       </TABLE>
       <br>
       <!-- stop navigation -->
      <?php
      }

      function commonFooter(){
      ?>
        <br>
        <!-- stop body -->
        </div>
        </body>
      </html>
      <?php
      }

      function helpHeader($title,$style) {

      global $PHP_SELF;
      ?>
      <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
      <html><head><title><?php echo $title; ?></title><link rel="stylesheet" href="<?php echo $style; ?>"></head>

      <!-- start body -->
      <body>
      <div align="center">

        <!-- start navigation -->
        <table FRAME=void height="20" bgcolor="#CCCCFF" width="250" >
        <tr>
          <td width="30%"><?php echo $title; ?>
          <td ALIGN="right"><a href="javascript:window.close();">close</a>
        </table>
        <!-- stop navigation -->
      <?php
      }

      function helpFooter(){
      ?>
        <br>
        <!-- stop body -->
        </div>
        </body>
      </html>
      <?php
      }

      function loginHeader($title, $style) {

      global $PHP_SELF, $conf;


      $conf[cookiealert] = "Diese Option erlaubt ein Auto-Login fr diesen Browser \"+
                          \"mit Ihrem Passwort und Ihrem Kennwort fr diese Seiten. \"+
                          \"Benutzen Sie diese Option nicht bei ffentlichen \"+
                          \"PC Systemen oder im Internetcafe. \"+
                          \"Das Auto-Login ist whrend " . ($conf[cookieseconds] / 60 ) . " Stunden aktiv.";
      ?>
      <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
      <html><head><title><?php echo $title; ?></title><link rel="stylesheet" href="<?php echo $style; ?>">

      <script type="text/javascript">
         <!-- Hide from older browsers
         function cookieREMARK() {
           if (document.loginform.check_it.checked)
             {
             if (!confirm("<?php echo $conf[cookiealert]; ?>"))
               {
               document.loginform.check_it.checked = false;
             }
           }
         }
         // unhide -->
      </script>
      </head>

      <!-- start body -->
      <body>
      <div align="center">

        <!-- start navigation -->
        <table FRAME=void height="20" bgcolor="#CCCCFF" width="<?php echo $conf[tableWidth]; ?>" >
        <tr>
          <td width="30%">
          <td ALIGN="right"><a href="javascript:history.back(-1);">back</a>
        </table>
        <!-- stop navigation -->
      <?php
      }

      function loginFooter(){
      ?>
        <br>
        <!-- stop body -->
        </div>
        </body>
      </html>
      <?php
      }

// ----------------------------------------------------------------------------------------
// functions : functional
// ----------------------------------------------------------------------------------------

      /**
      * returns number of colomns or rows in the data.txt file
      * urs@circle.ch, 16-1-2001
      */
      function evalFILE($myFILE, $item){          // get number of rows or cols

        $content = file($myFILE);                 // read file
        $myROWS = count($content);                // get number of lines
        $myLINES = explode("|",$content[0]);
        $myCOLS = count($myLINES);                // get number of arguments per line

        switch($item):
          case 'rows':
            return $myROWS;
            break;
          case 'cols':
            return $myCOLS;
            break;
        endswitch;
      }

      /**
      * get a specific entry from the data.txt file, like "author"
      * urs@circle.ch, 16-1-2001
      */
      function getITEM($myFILE, $row, $col ){     // rows, cols, args

        $content = file($myFILE);                 // read file
        $myROWS = count($content);                // get number of lines

        for($i=0; $i<$myROWS; $i++):              // split by seperator "|"
          $myLINES[$i] = explode("|",$content[$i]);
        endfor;
        $myCOLS = count($myLINES[0]);             // get number of arguments per line

      }

      /**
      * get a specific colomn from the data.txt file
      * urs@circle.ch, 16-1-2001
      */
      function getCOL($myFILE, $row, $arg ){      // $row->row; $arg=""->whole line, $arg=2->get arg 2

        $content = file($myFILE);                 // read file

        if($arg == ""):
          return $content[$row];
          break;
        else:
          $myLINE = explode("|",$content[$row-1]);
          return $myLINE[$arg];
        endif;
      }

      /**
      * i wrote this in the beginning of my php-experiance, not knowing that one
      * could use $HTTP_GET_VARS ;-)
      * urs@circle.ch, 16-1-2001
      */
      function evalQUERY($item){
        global $QUERY_STRING;

        $pairs = explode("&", $QUERY_STRING);

        for($i=0;$i<count($pairs);$i++):
          $query[$i] = explode("=", $pairs[$i]);
          if($query[$i][0] == $item):
            return $query[$i][1];
            break;
          endif;
        endfor;
      }

      /**
      * list a set of entries
      * urs@circle.ch, 16-1-2001
      */
      function listHEADLINES(){
          global $PHP_SELF, $conf, $pos, $stamp;

          $count = 15;
          $content = file($conf[myDataFile]);
          $size = count($content);

          for($i=0; $i<count($content); $i++):
            $myLINES[$i] = explode("|",$content[$i]);
          endfor;

          ?>
          <table border="0" cellspacing="0" cellpadding="0" width="600">
          <tr valign="top">
          <td height="1" colspan=6 ><hr width="100%" noshade size="1">
          <?php
          $tmp = $size-$pos;
          for($i=$tmp; $i>($tmp-$count); $i--):
            if(($content[$i] != '') && ($myLINES[$i][0] != "id")): // quit at contents, which are not existing but indexed
            ?>
              <tr bgcolor="<?php echo($i % 2 == 0 ? '#EFEFFF' : '#FFFFFF'); ?>">
                <td valign="top" align="left" width="80">
                <?php echo $myLINES[$i][1]; ?>
                <td valign="top" align="left" width="440">
                <a href="<?php echo basename($PHP_SELF)."?cmd=zoom&id=".$myLINES[$i][0]."&".$stamp; ?>"><?php echo stripslashes($myLINES[$i][2]); ?></a>
                <td valign="top" align="center" width="20">
                <a href="<?php echo basename($PHP_SELF)."?cmd=edit&id=".$myLINES[$i][0]."&".$stamp; ?>">edit</a>&nbsp;|
                <td valign="top" align="center" width="20">
                <a href="javascript:insertITEM('<?php echo basename($PHP_SELF)."?cmd=insert&id=".$myLINES[$i][0]."&".$stamp; ?>');">&nbsp;ins</a>&nbsp;|
                <td valign="top" align="center" width="20">
                <a href="javascript:deleteITEM('<?php echo basename($PHP_SELF)."?cmd=del&id=".$myLINES[$i][0]."&".$stamp; ?>');">&nbsp;del</a>&nbsp;|&nbsp;
                <td valign="top" align="right" width="20" >
                <input type="checkbox" name="<?php echo ( "id_".$myLINES[$i][0] ); ?>" <?php echo ( $myLINES[$i][5] == 1 ? 'checked' : ''); ?> >
            <?php
            endif;
          endfor;
          ?>
          <tr valign="top">
          <td height="1" colspan=6 ><hr width="100%" noshade size="1">
          </table>
          <?php

          ?>
          <!-- start pages index -->
             <table width="<?php echo $conf[tableWidth]; ?>" frame=below RULES=groups cellspacing="0" cellpadding="0" align="center" >
               <tr>
               <?php
               for($i=0; $i<$size; $i++):     // get number of pages -> a division by 0 can be avoided
                 if(!($i % $count)) $pages++;
               endfor;
               ?>
               <TD ALIGN="left" valign="top" style="font-size: 8pt" width="70%">
               <?php
               for($i=0; $i<$pages; $i++):    // print index of pages
                 if($pos == $i*$count):       // colorize and unlink the selected page
                   echo "<font color='red'><b>".($i+1)."</b></font>&nbsp;&nbsp;";
                 else:
                   ?><a href="<?php echo basename($PHP_SELF)."?cmd=list&pos=".($i*$count)."&".$stamp; ?>" style="font-size: 8pt"><?php echo $i+1; ?></a>&nbsp;
                   <?php
                 endif;
               endfor; ?>
               <TD colspan="2" ALIGN="right" valign="top" style="font-size: 8pt" width="30%">
               <?php echo $size-1; ?>&nbsp;nr.<?php
               if ($pos > 0):
                 ?>&nbsp;&nbsp;<b><a href="?cmd=list&pos=<?php echo $pos-$count."&".$stamp;?>">&lt;&lt;</a></b><?php
               endif;
               if($size > $pos+$count):
                 ?>&nbsp;<b><a href="?cmd=list&pos=<?php echo $pos+$count."&".$stamp;?>">&gt;&gt;</a></b><?php
               endif;
               ?>
               </td>
               </tr>
             </table>
          <!-- end pages index -->
          <?php
      }

      /**
      * zoom an existing entry
      * urs@circle.ch, 16-1-2001
      */
      function zoomITEM(){
        global $id, $conf, $stamp;

        $content = file($conf[myDataFile]);                 // read file

        for($i=0; $i<count($content); $i++):
          $myLINES[$i] = explode("|",$content[$i]);
          if($myLINES[$i][0] == $id) break;
        endfor;

        if( $id != "" ):
           echo "article id: <b>".$id."</b><br>";
           ?>
           <hr width="<?php echo $conf[tableWidth]; ?>" noshade size="1"><?php

           ?>
           <table width="<?php echo $conf[tableWidth]; ?>" border="0" cellspacing="0" cellpadding="0">
               <tr>
               <td width="50%">&nbsp;
               <td width="50%"><p><?php echo stripslashes(html2txt($myLINES[$i][1]))." - ".stripslashes(html2txt($myLINES[$i][4])); ?><p>
               <tr>
               <td width="50%">&nbsp;
               <td width="50%"><h2><?php echo stripslashes(html2txt($myLINES[$i][2])); ?></h2>
               <tr>
               <td width="50%">&nbsp;
               <td width="50%"><?php echo stripslashes(html2txt($myLINES[$i][3])); ?>
               <tr>
               <td colspan="2"><hr width="100%" noshade size="1">
               <tr>
               <td colspan="2" align="right"><a href="<?php echo basename($PHP_SELF)."?cmd=edit&id=".$id."&".$stamp; ?>">edit</a>&nbsp;
               <a href="javascript:history.go(-1);">back</a>
           </table>
           <?php
        endif;
      }

      /**
      * edit an existing entry
      * urs@circle.ch, 16-1-2001
      */
      function editITEM(){
        global $PHP_SELF, $conf, $id;

        echo "<!-- start editing -->\n";
        if($id != ""):
           $content = file($conf[myDataFile]);                 // read file

           for($i=0; $i<count($content); $i++) {
               $line = stripslashes($content[$i]);
               $myLINES[$i] = explode("|",$line);
               if( $myLINES[$i][0] == $id ) {
                   //echo $content[$i];
                   break;
               };
           };

           $tmp = str_replace("<br>", "\n", $myLINES[$i][3]);
           //$tmp = stripslashes($tmp);

          ?>
          <form name="editform" action="<?php echo basename($PHP_SELF); ?>" method="post" enctype="multipart/form-data">
          <input type="hidden" name="cmd" value="modify">
          <input type="hidden" name="id" value="<?php echo $id; ?>">

          <table frame=void RULES=void WIDTH="60%">
          <THEAD>
            <TR>
              <TH colspan="4">modify nr. <?php echo $id; ?>
          <TBODY>
            <tr>
              <TD width="50%">&nbsp;
              <td valign="top" align="right" width="50%">publish:
              <input name="publish" value="1" <?php echo($myLINES[$i][5] == 0 ? '' : checked); ?> type="checkbox">
            <TR>
              <TD><b>Datum
              <TD><input type="text" name="datum" class=w300 value="<?php echo htmlspecialchars(html2txt($myLINES[$i][1])); ?>">
            <TR>
              <TD><b>Titel
              <TD><input type="text" name="titel" class=w300 value="<?php echo htmlspecialchars(html2txt($myLINES[$i][2])); ?>">
            <TR>
              <TD><b>Text
              <TD><textarea name="text" cols="35" rows="20"><?php echo htmlspecialchars(html2txt($tmp)); ?></textarea>
            <TR>
              <TD><b>Autor
              <TD><input type="text" name="autor" class=w300 value="<?php echo htmlspecialchars(html2txt($myLINES[$i][4])); ?>" >
          <TFOOT>
            <TR align="center">
              <TD colspan="4">
          </table>
            <br>
            <input style="width:100; font:9pt" type="submit" value="change">
          </form>
           <?php
        endif;
        echo "<!-- start editing -->\n";
      }

      /**
      * modify an existing entry
      * urs@circle.ch, 16-1-2001
      */
      function modifyITEM(){
          global $id, $datum, $titel, $text, $autor, $publish, $conf;

          $content = file($conf[myDataFile]);

          if($datum == ""):
            $datum = date("d.m.Y");
          endif;

          if($publish == "1"):
            $doPUB = 1;
          else:
            $doPUB = 0;
          endif;

          $text = str_replace("|", "/", $text);
          $titel = str_replace("|", "/", $titel);
          $autor = str_replace("|", "/", $autor);
          $tmp = $id."|".$datum."|".$titel."|".$text."|".$autor."|".$doPUB;
          $tmp = str_replace("\n", "<br>", $tmp);
          $tmp = str_replace("\r", "", $tmp);
          $tmp = str_replace("\n", "", $tmp);
          $tmp = txt2html($tmp );

          // modify index record in the index file
          $content = file($conf[myDataFile]);
          $size = count($content);

          $fp = @fopen($conf[myDataFile].".tmp", "w+");

          for($line=0; $line<count($content); $line++) {
              $myLINES[$line] = explode("|", $content[$line] );
              if($myLINES[$line][0] != $id) {
                  fputs($fp, $content[$line] );
              } else {
                  fputs($fp, $tmp."\n");
              };
          };

          fclose($fp);
          unlink($conf[myDataFile]);
          rename($conf[myDataFile].".tmp", $conf[myDataFile]);
      }

      function evalMAXid(){
          global $id, $conf;

          $content = file($conf[myDataFile]);
          $size = count($content);

          $maxID = 0;
          for($line=1; $line<=$size; $line++):
            $tmpID = getCOL($conf[myDataFile],$line,"0");
            if($tmpID > $maxID) $maxID = $tmpID;
          endfor;

          return $maxID;
      }

      /**
      * insert a new entry and add a default content
      * urs@circle.ch, 16-1-2001
      */
      function insertITEM(){
          global $id, $datum, $titel, $text, $autor, $publish, $conf;

          // modify index record in the index file
          if($datum == ""):
            $datum = date("d.m.Y");
          endif;

          $content = file($conf[myDataFile] );
          $size = count($content);


          $new_id = evalMAXid()+1; // get latest id and assign new id-number
          $titel = "<font color='red'>Please enter a title...</font>";
          $text = "<font color='red'>Please enter a text...</font>";
          $tmp = $new_id."|".$datum."|".$titel."|".$text."|".$autor."|".$publish;

          $fp = @fopen($conf[myDataFile].".tmp", "w+" );

          for($line=0; $line<=$size; $line++):
            $myLINES[$line] = explode("|",$content[$line]);
            if($myLINES[$line][0] == $id) fputs($fp,$tmp."\n");
            fputs($fp,$content[$line]);
          endfor;

          fclose($fp);
          unlink($conf[myDataFile]);
          rename($conf[myDataFile].".tmp", $conf[myDataFile]);
      }

      /**
      * adding a new entry
      * urs@circle.ch, 16-1-2001
      */
      function addITEM(){
          global $datum, $titel, $text, $autor, $publish, $conf;

          if($datum == "") $datum = date("d.m.Y");
          $content = file($conf[myDataFile] );
          $size = evalFILE($conf[myDataFile] ,"rows");
          $id = evalMAXid()+1; // give new id-number

          $text = str_replace("|", "/", $text);
          $titel = str_replace("|", "/", $titel);
          $autor = str_replace("|", "/", $autor);
          $tmp = $id."|".$datum."|".$titel."|".$text."|".$autor."|".$publish;
          $tmp = str_replace("\n", "<br>", $tmp);
          $tmp = str_replace("\r", "", $tmp);
          $tmp = txt2html($tmp );
          $content[$size] = str_replace("\n", "", $tmp);

          $fp=@fopen($conf[myDataFile], "a");
          if($fp <= 0):
            ?>Error while opening a file.<br><?php
          endif;
          fputs($fp, $content[$size]."\n");
          fclose($fp);
      }

      /**
      * deleting an entry
      * urs@circle.ch, 16-1-2001
      */
      function delITEM(){
          global $conf;

          $id = evalQUERY("id");

          $content = file($conf[myDataFile] );
          $size = count($content);

          $fp = @fopen($conf[myDataFile].".tmp", "w+");

          for($i=0; $i<count($content); $i++):
            $myLINES[$i] = explode("|", $content[$i]);
            if($myLINES[$i][0] != $id):
              fputs($fp,$content[$i]);
            endif;
          endfor;

          fclose($fp);
          unlink($conf[myDataFile] );
          rename($conf[myDataFile] .".tmp", $conf[myDataFile] );

      }


      function doHELP(){
        ?>
        <SCRIPT language=JavaScript>
          window.location.href="help.php";
        </SCRIPT>
        <?php
      }

      /**
      * form for adding new entries
      * urs@circle.ch, 16-1-2001
      */
      function doFORM(){
        global $PHP_SELF, $conf;

        ?>
        <form action="<?php echo basename($PHP_SELF); ?>" method="post" enctype="multipart/form-data">
          <input type="hidden" name="cmd" value="add">

          <table frame=void RULES=void WIDTH="60%">
          <THEAD>
            <TR>
              <TH colspan="4">Add article
          <TBODY>
            <TR>
              <TD><b>Date
              <TD><input type="text" name="datum" class=w300>
            <TR>
              <TD><b>Title
              <TD><input type="text" name="titel" class=w300>
            <TR>
              <TD><b>Text
              <TD><textarea name="text" cols="35" rows="20" class=w300></textarea>
            <TR>
              <TD><b>Author
              <TD><input type="text" name="autor" class=w300>
          <TFOOT>
            <TR align="center">
              <TD colspan="4">
                <input type="submit" value="send">
          </table>
          </form>
        <?php
      }

      function redirect($cmd){
        global $PHP_SELF;
        ?>
        <SCRIPT language=JavaScript>
          window.location.href="<?php echo basename($PHP_SELF).$cmd; ?>";
        </SCRIPT>
        <?php
      }

      /**
      * testing, if cookies are enabled; NOT used within myNews
      * urs_at_circle_dot_ch, 16-1-2001
      */
      function testCookie() {
          global $PHP_SELF, $HTTP_GET_VARS;

          if ($HTTP_GET_VARS[mode] != "test") {
              setcookie ("COOKIE", "VALUE");
              header ("Location: " . basename($PHP_SELF) . "?mode=test");
              exit;
          } elseif ($COOKIE == "VALUE") {
              echo "Cookies are activated on your system!";
          } else {
              echo "Enable cookies on your sytem.";
          };
      }

      /**
      * login form for first login
      * urs_at_circle_dot_ch, 16-1-2001
      *
      */
      function LoginForm(){
            global $conf;

            $header = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"><HTML><HEAD><TITLE>login form</TITLE><link rel="stylesheet" href="style.php"></HEAD><BODY>';
            $footer = '</BODY></HTML>';

            loginHeader("login", $conf[myStyle]); // echo $header;

            ?>
            <form method="post" action="<?php echo basename($PHP_SELF); ?>" name=loginform>
            <table frame=none rules=none WIDTH="300">

            <tr>
              <td align="left">
              login:
              <td align="left">
              <input type="text" name="login" maxlength=50 size=10 style="width: 90px; font-size: 10px">
            <tr>
              <td align="left">
              password:
              <td align="left">
              <input type="password" name="passwd" maxlength=50 size=10 style="width: 90px; font-size: 10px">

            <tr>
              <td align="left">
              Logininformation speichern.
              <td align="left">
              <input name="check_it" value="1" type="checkbox" onclick="cookieREMARK()" >

            <tr>
              <td align="left">&nbsp;
              <td align="left">&nbsp;
            <tr>
              <td align="left">
              &nbsp;
              <td align="left">
              <input type=submit name="sent" value="login" style="width: 30px; heigth: 18px; font-size: 10px">
            </table>
            </form>

            <script type="text/javascript">
            <!--
            if (document.loginform) {
               document.loginform.login.focus();
            }
            // -->
            </script>
          <?php
          loginFooter();
      }

      /**
      * authenticate versus the $authentication array or cookie
      * urs_at_circle_dot_ch, 16-1-2001
      *
      */
      function authenticate(){
          global $PHP_SELF, $HTTP_POST_VARS, $HTTP_COOKIE_VARS;
          global $conf, $authentication;

          // coming from login form
          if(strlen($HTTP_POST_VARS[sent] )) {
            $login_ok = 0;
            if (strlen($HTTP_POST_VARS[login] ) AND strlen($HTTP_POST_VARS[passwd] )) {
              for($i=0; $i<count($authentication ); $i++) {
                 if ($authentication[$HTTP_POST_VARS[login]] == $HTTP_POST_VARS[passwd] ) {
                    if(!strlen($HTTP_POST_VARS[check_it])) $conf[cookielifetime] = "";
                    setcookie('login', $HTTP_POST_VARS[login], $conf[cookielifetime], "/", "", 0 );
                    setcookie('passwd', $HTTP_POST_VARS[passwd], $conf[cookielifetime], "/", "", 0 );
                    return 1; // authentication succeeded
                    $login_ok = 1;
                    break;
                }
              }
            }
            if(!$login_ok ) {
              return 0;       // access denied
            }
          // coming from anywhere else
          } else {
            for($i=0; $i<count($authentication); $i++) {
                if (($authentication[$HTTP_COOKIE_VARS[login]] == $HTTP_COOKIE_VARS[passwd] )
                                                      AND (strlen($HTTP_COOKIE_VARS[passwd]) ) ) {
                    return 1; // authentication succeeded
                    $login_ok = 1;
                    break;
                }
            }
            if(!$login_ok ) {
              return 0;       // access denied
            }
          }
      }

      /**
      * transform txt to html -> "" to "&auml;"
      * urs_at_circle_dot_ch, 16-1-2001
      *
      */
      function txt2html ($str = "") {
          global $HTML_ENTITIES;

          $trans = get_html_translation_table(HTML_ENTITIES );
          return strtr($str, $trans);
      }

      /**
      * transform html to txt -> "&auml;" to ""
      * urs_at_circle_dot_ch, 16-1-2001
      *
      */
      function html2txt ($str = "") {
          global $HTML_ENTITIES;

          $trans = array_flip(get_html_translation_table(HTML_ENTITIES ));
          $trans["&amp;"] = "&";
          return strtr($str, $trans);
      }

?>