<?php
// ----------------------------------------------------------------------------------------
// Topic:     News Database based on Files
// File:      wap.inc.php
// ----------------------------------------------------------------------------------------


      /**
      * Topic:  A set of conversion functionality to convert to proper ASCII,
      *         like &#228; for , which allows to generate valid WML.
      * Author: Urs Gehrig <urs_at_circle_dot_ch>,  Federico <federico@pomi.net>
      * Date:   7-12-2000
      * Ref:    http://www.php.net/manual/function.htmlentities.php
      */
      function literal2numeral(&$value, $key) {
          $value = "&#".ord($key).";";
      }

      $trans = get_html_translation_table (HTML_ENTITIES );
      array_walk ($trans, 'literal2numeral');
      reset($trans);

      function asciiencode($string) {
          global $trans;

          $mytrans = array( "\n" => "<br/>" );
          $tmp = strtr(html2txt($string ), $trans);
          return strtr($tmp, $mytrans );
      }

      /**
      * Topic:  Create a single wml file
      * Author: Urs Gehrig <urs@circle.ch>
      * Date:   5-12-2000
      *
      */
      function export_single_wml($datafile, $id) {

          global $wap, $HTML_ENTITIES, $trans;

          // http://www.php.net/manual/function.strip-tags.php
          $content = file($datafile);
          $size = count($content);

          for($i=0; $i<count($content); $i++) {
              $tmp = strip_tags(stripslashes(str_replace("<br>", "\n", $content[$i] )));
              $myLINES[$i] = explode("|", $tmp );

              if($myLINES[$i][0] == $id){

                  if (!$fp = @fopen($wap[datadir] . $wap[datafile] . $id . ".wml", "w+")) {
                      echo ("Unable to write to outputfile\n");
                  } else {
                      //$trans = get_html_translation_table (HTML_ENTITIES);
                      fputs ( $fp, "<?xml version=\"1.0\" ?>\n" );
                      fputs ( $fp, "<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">\n" );
                      fputs ( $fp, "<wml>\n" );
                      fputs ( $fp, "<card id=\"WAP\" title=\"ztpv.ch\">\n" );
                      fputs ( $fp, "<do type=\"prev\" label=\"Back\">\n<prev/>\n</do>\n" );
                      fputs ( $fp, "<p>" . asciiencode ($myLINES[$i][2] ) . "</p>\n" );
                      fputs ( $fp, "<p>" . asciiencode ($myLINES[$i][3] ) . "</p>\n" );
                      //fputs ( $fp, "<p>" . asciiencode (nl2br(ereg_replace("&nbsp;", " ", ($myLINES[$i][3] )))) . "</p>\n" );
                      fputs ( $fp, "</card>\n</wml>\n" );
                      fclose( $fp );
                  }
              }
          }
      }

      /**
      * Topic:  Create ztpv_x.wml index files
      * Author: Urs Gehrig <urs_at_circle_dot_ch>
      * Date:   6-12-2000
      *
      */
      function export_all_wml($datafile) {

          global $wap, $HTML_ENTITIES, $trans;

          // http://www.php.net/manual/function.strip-tags.php
          $content = file($datafile);
          $size = count($content);

          for($i=1; $i<count($content); $i++) {
              $tmp = strip_tags(stripslashes(str_replace("<br>", "\n", $content[$i] )));
              $myLINES[$i] = explode("|", $tmp );

              $wap[tmp_name] = $wap[datafile] . $myLINES[$i][0] . ".wml";
              //if(!file_exists($wap[datadir] . $wap[tmp_name])){

                  if (!$fp = @fopen($wap[datadir] . $wap[tmp_name], "w+")) {
                      echo ("Unable to write to outputfile\n");
                  } else {
                      //$trans = get_html_translation_table (HTML_ENTITIES);
                      fputs ( $fp, "<?xml version=\"1.0\" ?>\n" );
                      fputs ( $fp, "<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">\n" );
                      fputs ( $fp, "<wml>\n" );
                      fputs ( $fp, "<card id=\"WAP\" title=\"myWAP\">\n" );
                      fputs ( $fp, "<do type=\"prev\" label=\"Back\">\n<prev/>\n</do>\n" );
                      fputs ( $fp, "<p>" . asciiencode ($myLINES[$i][2] ) . "</p>\n" );
                      fputs ( $fp, "<p>" . asciiencode ($myLINES[$i][3] ) . "</p>\n" );
                      //fputs ( $fp, "<p>" . asciiencode (nl2br(ereg_replace("&nbsp;", " ", ($myLINES[$i][3] )))) . "</p>\n" );
                      fputs ( $fp, "</card>\n</wml>\n" );
                      fclose( $fp );
                  }
              //}
          }
      }

      /**
      * Topic:  Create wap.wml index file for last x entries
      * Author: Urs Gehrig <urs_at_circle_dot_ch>
      * Date:   6-12-2000
      *
      */
      function export_index_wml($datafile) {

          global $wap, $HTML_ENTITIES, $trans;

          // http://www.php.net/manual/function.strip-tags.php
          $content = file($datafile);
          $size = count($content);

          for($i=1; $i<count($content); $i++) {
              $tmp = strip_tags(stripslashes(str_replace("<br>", "\n", $content[$i] )));
              $myLINES[$i] = explode("|", $tmp );
          }

          if (!$fp = @fopen($wap[waproot] . $wap[indexfile], "w+")) {
              echo ("Unable to write to outputfile\n");
          } else {
              fputs ( $fp, "<?xml version=\"1.0\" ?>\n" );
              fputs ( $fp, "<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">\n" );
              fputs ( $fp, "<wml>\n" );
              fputs ( $fp, "<template>\n" );
              fputs ( $fp, "<do type=\"accept\" label=\"myWAP home\" name=\"start\">\n ");
              fputs ( $fp, "<go href=\"" . $wap[url] . "\"/>\n");
              fputs ( $fp, "</do>\n");
              fputs ( $fp, "<do type=\"prev\" label=\"Back\">\n");
              fputs ( $fp, "<prev/>\n");
              fputs ( $fp, "</do>\n");
              fputs ( $fp, "</template>\n");
              fputs ( $fp, "<card id=\"WAP\" title=\"myWAP site\">\n\n");
              if($wap[logoenable]) fputs ( $fp, "<p><img src=\"" . $wap[logodir] . "\" alt=\"myWAP Logo\"/></p>\n");
              fputs ( $fp, "<p>Welcome to myWAP!<br/>");

              // special handling of 5 last messages
              if(count($content) < $wap[lastentries]+1){
                  $lowerlimit = 0;
              } else {
                  $lowerlimit = count($content)-($wap[lastentries]+1);
              }

              // http://www.php.net/manual/function.get-html-translation-table.php
              //$trans = get_html_translation_table (HTML_ENTITIES);
              for($j=count($content)-1; $j>$lowerlimit; $j--) {
                  //$tmp = htmlspecialchars(stripslashes($myLINES[$j][2]));
                  $tmp  = stripslashes($myLINES[$j][2]);
                  //$link = "<a href=\"" . $wap[detail] . "ztpv_" . $myLINES[$j][0] . ".wml\">" . strtr ($tmp, $trans) . "...</a>\n<br/>\n";
                  $link = "<a href=\"" . $wap[detail] . $wap[datafile] . $myLINES[$j][0] . ".wml\">" . asciiencode ($tmp ) . "...</a>\n<br/>\n";

                  fputs ( $fp,  $link );
              }
              fputs ( $fp, "</p>\n</card>\n</wml>\n");
              fclose( $fp );
          }



      }

      /**
      *
      * get the contents of the directory
      */
      function get_content($directory) {

          $content = array();

          @chdir($directory);
          $dir = opendir(".");
          while ($file = @readdir($dir)) {
              if((is_file($file)) AND strstr($file, $wap[datafile]) ) $content[] = $file;
          }
          @chdir("../");

          return $content;
      }


      /**
      * Urs Gehrig <urs_at_circle_dot_ch>
      * use like:
      *     $string = "Winamp is now freeware! Thanks to all who have previously registered, your support is really appreciated!";
      *     echo string_cut($string, 13, "?url=where_ever_you_want");
      * or just for cutting:
      *     echo string_cut($string, 13);
      */
      function string_cut( $string, $word_count, $query) {

          $StringArray = explode( " ", $string);
          for($i=0; $i<$word_count; $i++){
              $string_cut .= " ".$StringArray[$i];
          }

          if(strlen($query)) {
              return "$string_cut"."... [<a href=\"$query\" title=\">>mehr\" onMouseOver=\"window.status='>>mehr'; return true;\" onMouseOut=\"window.status=' '; return true;\">mehr</a>]";
          } else {
              return "$string_cut...";
          }
      }

?>