<?php
// --------------------------------------------------------------------------------
// topic:     News Database, based on Files -> myNEWS
// author:    Copyright (c) by Urs Gehrig <urs_at_circle_dot_ch>
// source:    http://www.circle.ch/scripts/code/news.zip
// version:   2.1.0
// update:    24-01-2001
// licence:   GPL
// PHP:       php-4.0.0-win32
//
// handling:  add, modify, del, insert news-articles into a file and display
//            them on your top-page of your website.
//
// Attention: Put the data-folder above the web-root where it is hidden from
//            external manipulation.
//
// Enjoy!
// --------------------------------------------------------------------------------
// History:
// - V2.1.0: (24-01-2001)
//      > added include, wap and doc folders
//      > generate now your wml-files for mobile phones from myNews
//      > removed passwd.txt file and moved password/login pairs to config.php
//      > added a "backup" feature, which puts a html file to the data folder
//        having all entries listed.
//      > added some cookie-frontend; if selected, cookie will remain longer,
//        if unselected, cookie will stay for a session.
// - V2.0.4: (26-11-2000)
//      > config.inc.php and rss.php files added
//      > modified index.php and shared.inc.php with rdf_export() function. this will
//        function exports an RSS compliant channel file mynews.rdf to the data folder.
// - V2.0.3: (14-08-2000)
//      > added example files zoom.php and list_all_news.php
//      > added a "home" link in the header
//      > myStyle renamed to style
// - V2.0.2:
//      > modifications in html tables for a better look&feel in netscape
//      > modified cookie-login
//      > timestamp to force the browser to refresh the pages after modification
//      > moved mynews.txt to a seperate directory, called "data"
// - V2.0.1:
//      > added cookie-login
//      > myCONTpath renamed to myDataFile
// - V2.0.0:
//      > listALL() function removed due to redundsancy
// - V1.2.3:
//      > id|datum|titel| ... removed from content file
//      > automatic stringreplacement to avoid an unwanted delimiter in the data
//      > created mynews.inc.php -> including all functions
//      > page index for list and headline commands
//      > modify from headline -> zoom
// - V1.2.2:
//      > initial published release
// --------------------------------------------------------------------------------
// TODO:
// x rdf channel export
// - multilingual package
// - adding more security
// x active/inactive an article by selecting a tick in the list
// - a html-tag editor for non-html users
// x a page wrapper, like on search-engines
// --------------------------------------------------------------------------------

// --------------------------------------------------------------------------------
// defines / includes
// --------------------------------------------------------------------------------

  include("config.php");                                 // configuration settings
  include("include/shared.inc.php");                     // general functions
  include("include/rss.inc.php");                        // rdf/rss channel file generation
  include("include/wap.inc.php");                        // wap/wml file generation
  include("include/backup.inc.php");                     // backup datafile to html

// --------------------------------------------------------------------------------
// main switch
// --------------------------------------------------------------------------------

  //chmod(myDataFile, 0700);
  if(!authenticate())  {
      LoginForm();

  } else {
    srand(time());
    $stamp = md5(microtime(rand()));
    $stamp = "r=" . substr ($stamp, 0, 5) . "_$login";

    switch($cmd):
      case 'zoom':
        commonHeader($conf[myTitle], $conf[myStyle] );
        zoomITEM();
        break;
      case 'edit':
        commonHeader($conf[myTitle], $conf[myStyle] );
        editITEM();
        commonFooter();
        break;
      case 'modify':
        modifyITEM();
        redirect("?cmd=list&".$stamp);
        break;
      case 'list':
        commonHeader($conf[myTitle], $conf[myStyle] );
        listHEADLINES();
        commonFooter();
        break;
      case 'new':
        commonHeader($conf[myTitle], $conf[myStyle] );
        doFORM();
        commonFooter();
        break;
      case 'add':
        echo "adding database entry ...";
        addITEM();
        redirect("?cmd=list&".$stamp);
        break;
      case 'insert':
        insertITEM();
        redirect("?cmd=list&".$stamp);
        break;
      case 'del':
        echo "Deleting id ".evalQUERY("id")." ...";
        delITEM();
        redirect("?cmd=list&".$stamp);
        break;
      case 'help':
        doHELP();
        break;
      case 'rdf':
        export_rdf($conf[myDataFile]);
        redirect("?cmd=list&".$stamp);
        break;
      case 'wml':
        export_all_wml($conf[myDataFile]);
        export_index_wml($conf[myDataFile]);
        redirect("?cmd=list&".$stamp);
        break;
      case 'backup':
        //$tmp = doubleval(ereg_replace('^0\.([0-9]*) ([0-9]*)$', '\\2.\\1', microtime()));
        //echo "<a href=$PHP_SELF?r=$tmp>Export datafile...</a>";
        backup_news($conf[myDataFile]);
        redirect("?cmd=list&".$stamp);
        break;
      default:
        redirect("?cmd=list");
        break;
    endswitch;
  }
  //chmod( myDataFile, 0000 );
?>